/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// chocolux by Auld
// http://www.pouet.net/prod.php?which=49796
// Conversion to ShaderToy by Michael Pohoreski
// Source Code: http://sizecoding.blogspot.com/2008/02/chocolux-1k-intro.html

/* Original vertex and fragment shaders

#pragma data_seg(".shad1")
char *vsh="\
varying vec3 s[4];\
void main(){\
gl_Position=gl_Vertex;\
s[0]=vec3(0);\
s[3]=vec3(sin(abs(gl_Vertex.x*.0001)),cos(abs(gl_Vertex.x*.0001)),0);\
s[1]=s[3].zxy;\
s[2]=s[3].zzx;\
}"; 

#pragma data_seg(".shad2")
char *fsh="\
varying vec3 s[4];\
void main(){\
float t,b,c,h=0;\
vec3 m,n,p=vec3(.2),d=normalize(.001*gl_FragCoord.rgb-p);\
for(int i=0;i<4;i++){\
t=2;\
for(int i=0;i<4;i++){\
b=dot(d,n=s[i]-p);\
c=b*b+.2-dot(n,n);\
if(b-c<t)if(c>0){m=s[i];t=b-c;}\
}\
p+=t*d;\
d=reflect(d,n=normalize(p-m));\
h+=pow(n.x*n.x,44.)+n.x*n.x*.2;\
}\
gl_FragColor=vec4(h,h*h,h*h*h*h,h);\
}";

loop: 
    t=GetTickCount();
	glRecti(t,t,-t,-t);
	SwapBuffers(hDC);
*/

void main()
{
    // Original Win32 code was using milliseconds and converting to seconds.
    vec3 s[4];
    s[0] = vec3(0);
    s[3] = vec3(sin(abs( iGlobalTime*.1)),cos(abs(iGlobalTime*.1)),0);
    s[1] = s[3].zxy;
    s[2] = s[3].zzx;

    float t,b,c,h=0.;
    vec3 m, n, p=vec3(.2), d = normalize(.001*gl_FragCoord.rgb-p);
    for( int i = 0; i < 4; i++ )
    {
        t = 2.;
        for(int i=0; i < 4; i++ ) // intentional re-use of same var i ??
        {
            b = dot(d, n = s[i] - p );
            c = b*b+.2-dot(n,n);
            if (b - c < t)
                if (c > 0.)
                {
                    m = s[i];
                    t = b - c;
                }
        }
        p += t*d;
        d = reflect(d,n=normalize(p-m));
        h += pow(n.x*n.x,44.) + n.x*n.x * .2;
    }
    gl_FragColor = vec4(h,h*h,h*h*h*h,1.0); // original: a=h
} 